//******************************************
// file			: main.c
// version		: V1.0
// brief		: main program
// note			:
//****************************************** 
/*							Pin Assignment
*********************************************************************
.........................-----------------............................
01.VSS.................01|O              |20.VDD
02.P00/XIN.............02|               |19.P40/AIN0/KWI0
03.P01/XOUT............03|     QFN-20    |18.P41/AIN1/KWI1
04.P10/RESETB..........04|               |17.P42/AIN2/KWI2
05.P71/TC01/PWM01B.....05|               |16.P43/AIN3/KWI3/VREF
06.P90/TX/RX...........06|     LQFP-20   |15.P44/AIN4/KWI4       
07.P91/RX/TX...........07|               |14.P74/DVOB/AIN8/SI/KWI13
08.P72/TCA0/PPGA0B.....08|	             |13.P76/INT3/SCLK/KWI15
09.P82/TC04/PWM04B.....09|               |12.P70/TC00/PWM00B
10.P83/TC05/PWM05B.....10|	             |11.P75/INT2/SO/KWI14
.........................-----------------............................
*********************************************************************/
//******************************************
//Stack Pointer	=	0x23f (If use mq6821_x_startup.asm)
//Ram range = 0x40~0x23f
//******************************************
#ifndef	IO_MEM
#define	IO_MEM
#endif  
#include "MQ6821.h"
#include "MQ6812_REG_BIT.h"
#include "iApp.h"
#include "OPmode.h"


//-- header guards --//


//-- function definition --//



void main()
{
//----------------------------------------------------------------------//
//****** IO, CGCR and P10/P40/P41 initialization during debugging ****************//
//----------------------------------------------------------------------//
	SYSTEM_INIT();		// IO, CGCR and P10/P40/P41 initialization during debugging
//----------------------------------------------------------------------//
	WDCDR.byte = 0x4e;				// clear wdt

//--------------------------------------------------------------------------------------------------//
//	Please set the external crystal (HXTAL/LXTAL) from <OPmode.h> and refer to the following instructions:
//.....................................................................................
//#undef	XTAL_High		// define an external high-frequency crystal: #define(use crystal) / #undef(don't use crystal) :
//#undef	XTAL_Low		// define an external low-frequency crystal: #define(use crystal) / #undef(don't use crystal) :
//.....................................................................................
//	please change the above program in the <OPmode.h> file
//	please pay attention to the external crystal switching in this document
//--------------------------------------------------------------------------------------------------//


	WDCDR.byte = 0x4e;				// clear wdt
//* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
	while(1)
	{
		WDCDR.byte = 0x4e;			// clear wdt
		__asm("CPL (_P8DR).2");
		__asm("CPL (_P8DR).2");
		__asm("CPL (_P8DR).2");
		__asm("CPL (_P8DR).2");
	}
//* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *

}




